/*********************************************************************
**********************************************************************
**********                                                  **********
**********          pscg_hand.c                             **********
**********                              by Kenji with Tail  **********
**********                                                  **********
**********************************************************************
*********************************************************************/

#indluce "pscg_hand.h"

#define DEVPS "/dev/ttyS0"
#define DEVCG "/dev/ttyS1"
#define BAUDPS 38400
#define BAUDCG 38400
#define LEFT_PS 1
#define RIGHTPS 2



/***   ѥѡ   ***/
double goo_pscg_hs[5][5] = {{6, 6, 20, -2, 0},
			    {18, 38, 69, 5, 0},
			    {13, 39, 75, 0, 0},
			    {15, 33, 70, 7, 0},
			    {8, 12, 47, 15, 0}};
double par_pscg_hs[5][5] = {{0, 0, 0, 0, 0},
			    {0, 0, 0, 0, 0},
			    {0, 0, 0, 0, 0},
			    {0, 0, 0, 0, 0},
			    {0, 0, 0, 0, 0}};


/***   С   ***/
static vec offset_wst_cg_hs[2] = {{0, 0, 10}, {-180, 0, 0}};
static vec gain_wst_cg_hs[2] =   {{7, 7, 7}, {1, 1, 1}};


/***** С/PS   *****/
int  init_pscg_hs()
{
  int i;

  fprintf(stderr, "init_data_hs: Now, init. ps, cg.\n");
  i  = Init_ps(DEVPS,  BAUDPS);
  i *= Init_cg(1, DEVCG, BAUDCG);

  if(i == 0){
    fprintf(stderr, "Init_ps, cg failed.\n");
    return -1;
  }
  SetStation_ps(LEFT_PS, STL_PS);
  SetStation_ps(RIGHTPS,  ON_PS);

  fprintf(stderr, "\nDo exit_pscg_hs()\n");
//  fprintf(stderr, "\nPlease put Transmitter...\n");
  return 0;
}


/*****     CyberGlove/PS       *****/
int exit_pscg_hs()
{
  int i;

  i  = Close_ps();
  i *= Close_cg(1);
	
  if(i == 0){
    fprintf(stderr, "Close_ps, cg failed.");
    return (-1);
  }

  return (0);
}


/*****     PosOri_ps ΰָꤹ     *****/
static void change_ps_hs(hand_type_hs *h, PosOri_ps po, int stn)
{
  int i;

  static double po1[5][6] = {{0, 0, 0, 0, 0, 0},
			    {0, 0, 0, 0, 0, 0},
			    {0, 0, 0, 0, 0, 0},
			    {0, 0, 0, 0, 0, 0},
			    {0, 0, 0, 0, 0, 0}},
    po2[5][6] = {{0, 0, 0, 0, 0, 0},
		 {0, 0, 0, 0, 0, 0},
		 {0, 0, 0, 0, 0, 0},
		 {0, 0, 0, 0, 0, 0},
		 {0, 0, 0, 0, 0, 0}};

    for(i = 0; i < 6; i++){
      if((po[i] - po1[stn][i]) * (po1[stn][i] - po2[stn][i]) < 0)
	po[i] = po1[stn][i];
      po2[stn][i] = po1[stn][i];
      po1[stn][i] = po[i];
    }

    h->wst_cg_hs[0][0] =-gain_wst_cg_hs[0][0] * (po[1] - offset_wst_cg_hs[0][0]);
    h->wst_cg_hs[0][1] =-gain_wst_cg_hs[0][1] * (po[2] - offset_wst_cg_hs[0][1]);
    h->wst_cg_hs[0][2] = gain_wst_cg_hs[0][2] * (po[0] - offset_wst_cg_hs[0][2]);

    h->wst_cg_hs[1][0] =-gain_wst_cg_hs[1][0] * (po[3] - offset_wst_cg_hs[1][0]);
    h->wst_cg_hs[1][1] = gain_wst_cg_hs[1][1] * (po[4] - offset_wst_cg_hs[1][1]);
    h->wst_cg_hs[1][2] =-gain_wst_cg_hs[1][2] * (po[5] - offset_wst_cg_hs[1][2]);
}


/*****     CyberGlove γ٤ꤹ     *****/
static int change_cg_hs(hand_type_hs *h)
{
  int f, j, l;

  Angle_cg angle;

  static int offset[6][4] = {{100, 100, 130, 80},
			     {70, 70, 80, 165},
			     {75, 75, 70, 165},
			     {75, 75, 85, 167},
			     {58, 58, 62, 149},
			     {90, 160, 120, 0}};

  static double gain[6][4] = {{.87, .80, .50, -.5},
			     {.77, .77, .67, -.15},
			     {.80, .80, .72, .15},
			     {.88, .88, .72, .3},
			     {.66, .66, .70, .3},
			     {-.7, -.51, -.5, 0}};

  static int i[6][4]      = {{2, 1, 0, 3},
			     {5, 5, 4, 8},
			     {7, 7, 6, 8},
			     {10, 10, 9, 11},
			     {13, 13, 12, 14},
			     {16, 17, 15, 0}};

  l = Request_cg(1, angle);

  for(f = THUMB; f <= LITTLE; f++){
    for(j = 0; j < 4; j++){
      h->agl_hs[f][j] = gain[f][j] * (angle[i[f][j]] - offset[f][j]);
    }
  }

  h->wst_cg_hs[2][0]  = gain[5][0] * (angle[17] - offset[5][0]);
  h->wst_cg_hs[2][1]  = gain[5][1] * (angle[16] - offset[5][1]);
  h->wst_cg_hs[2][2]  = gain[5][2] * (angle[15] - offset[5][2]);

  return l;
}


/*****   ps, cg ΰָꤹ롢Re:stylus   *****/
/*****   d3,4: dummy for PS, cg: switch of CyberGlove   *****/
int input_pscg_hs(hand_type_hs *hl, hand_type_hs *hr, PosOri_ps d3, PosOri d4, int cg)
{
  int i, j, stl, lit;
  PosOri_ps p1, p2;

  stl =  PosRequest_ps(p1, p2, d3, d4);
  change_ps_hs(*hl, p1, 1);
  change_ps_hs(*hr, p2, 2);
  if (stl == 0){
    for (i = 0; i < 5; i++){
      for (j = 0; j < 5; j++){
	hl.agl_hs[i][j] = par_pscg_hs[i][j];
      }
    }
  } else {
    for (i = 0; i < 5; i++){
      for (j = 0; j < 5; j++){
	hl.agl_hs[i][j] = goo_pscg_hs[i][j];
      }
    }
  }    
  lit = change_cg_hs(hand_type_hs *hr);

  return stl;
}



