/*********************************************************************

          ps.h: PolhemusSensor device driver

                                        Kenji with Tail

*********************************************************************/


#ifndef _PS_H_
#define _PS_H_

#define POSORI_NUM_PS 6
typedef float PosOri_ps[POSORI_NUM_PS];

/* Init_ps() initialize PolhemusSensor
 *    Returns False (zero) if failed
 *    Returns True (non-zero) if successful
 *    give port:  serial port device file name, ex "/dev/ttyS0"...
 *         baud:  baud rate, ex 38400...
 */
int Init_ps(char *port, long int baud);

/* Close_ps() closes the port opened by Init_ps()
 *    Returns False (zero) if failed
 *    Returns True (non-zero) if successful
 */
int Close_ps(void);

/* Reset_ps() resets ps
 *    Returns False (zero) if failed
 *    Returns True (non-zero) if successful
 */
int Reset_ps(void);

/* SetStation_ps() sets activation of station 1-4
 *    Returns False (zero) if failed
 *    Returns True (non-zero) if successful
 *    give stn:   station nummber.
 *         act:   active: ON_PS, disactive: OFF_PS,
 *                active & stylus: STL_PS (only stn#1).
 */
#define OFF_PS 0
#define  ON_PS 1
#define STL_PS 2
int SetStation_ps(int stn, int act);

/* PosRequest_ps() requests position and orient
 *    Returns 1 if station#1 is stylus and button is ON
 *    Returns 0 other else
 *    give p*:    position/orient structur.
 */
int PosRequest_ps(PosOri_ps p1, PosOri_ps p2, PosOri_ps p3, PosOri_ps p4);

#endif

