/*********************************************************************

          cg.h: CyberGlove device driver

                                        Kenji with Tail

*********************************************************************/


#ifndef _CG_H_
#define _CG_H_

#define ANGLE_NUM_CG 25
/*typedef char Angle_cg[ANGLE_NUM_CG];*/
typedef unsigned char Angle_cg[ANGLE_NUM_CG];
			/* on x86, casting from char to int, */
			/* ex. 150 -> -106 T_T. so unsigned. */

/* Init_cg() initialize cg
 *    Returns False (zero) if faiiled
 *    Returns True (non-zero) if successful
 *    give cg_id: cg-number you named, max is 4.
 *         port:  serial port device file name, ex "/dev/ttyS0"...
 *         baud:  baud rate, ex 38400...
 */
int Init_cg(int cg_id, char *port, long int baud);

/* Close_cg() closes the port opened by Init_cg() with cg_id
 *    Returns False (zero) if failed
 *    Returns True (non-zero) if successful
 *    give cg_id: cg-number you named.
 */
int Close_cg(int cg_id);

/* ReInit_cg() re-initialize cg information
 *    Returns False (zero) if failed
 *    Returns True (non-zero) if successful
 *    give cg_id: cg-number you named.
 */
int ReInit_cg(int cg_id);

/* ReStart_cg() re-start cg firmware
 *    Returns False (zero) if failed
 *    Returns True (non-zero) if successful
 *    give cg_id: cg-number you named.
 */
int ReStart_cg(int cg_id);

/* Request_cg() requests angles
 *    Returns 0 if light is OFF
 *    Returns 1 if light is ON
 *    give cg_id: cg-number you named.
 */
int Request_cg(int cg_id, Angle_cg angle);

/* Light_cg() sets and/or requests light
 *    Returns False (zero) if failed
 *    Returns True (non-zero) if successful
 *    give cg_id: cg-number you named.
 *         req:   light off/on: OFF_CG/ON_CG (independent switch, no get)
 *                getting light: LIT_CG      (dependent switch,  getting)
 */
#define OFF_CG 0
#define  ON_CG 1
#define LIT_CG 2
int Light_cg(int cg_id, int req);

/* Vibrate_cg() actuate CyberTouch Vibrater
 *    Returns False (zero) if failed
 *    Returns True (non-zero) if successful
 *    give cg_id: cg-number you named.
 *         fin:   finger number: 0-5, 5 is palm
 *         vib:   value: 0-255, 0 is off (1-64 is very small)
 */
int Vibrate_cg(int cg_id, int fin, int vib);

#endif
